﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

using PdfSharp.Pdf;
using PdfSharp.Drawing;

namespace PI.ZB.N1200.ELearning.BL
{
    public static partial class PDFReport
    {
        /// <summary>
        /// Klasa tworzaca dokumenty PDF
        /// </summary>
        internal class PDFCreator
        {

            private const string _fontName = "Tahoma";

            // Set font encoding to unicode
            private XPdfFontOptions options = new XPdfFontOptions(PdfFontEncoding.Unicode, PdfFontEmbedding.Always);


            // Set up the fonts to be used on the pages
            private XFont _baseFont;
            private XBrush _fontColor;

            private XFont _standardFont;
            private XFont _boldFont;

            private XFont _smallFont;
            private XFont _smallBoldFont;

            // dokument PDF
            private PdfDocument _document = null;
            private XGraphics _gfx;
            private PdfPage _page;

            public PDFCreator(string ReportFontDir)
            {
                _baseFont = new XFont(_fontName, 12, XFontStyle.Regular, options);
                _fontColor = new XSolidBrush(XColor.FromArgb(99, 0, 0));

                _standardFont = new XFont(_fontName, 16, XFontStyle.Regular, options);
                _boldFont = new XFont(_fontName, 16, XFontStyle.Bold, options);

                _smallFont = new XFont(_fontName, 14, XFontStyle.Regular, options);
                _smallBoldFont = new XFont(_fontName, 14, XFontStyle.Bold, options);
            }

            public void CreateCert(
                string PDFProjectName, string PDFTitle, string PDFAuthor,
                string DestinationFileName,
                string CertFileBackgroundName,
                string StudentName,
                string StudentEvaluationName,
                string StudentEndTestEvaluationName,
                DateTime ExamDate
                )
            {
                BeginDocument(PDFProjectName, PDFTitle, PDFAuthor, DestinationFileName);
                AddNewPageWihtBackground(CertFileBackgroundName);

                /*
ę 281 \u0119
Ę 280 \u0118
ó 243 \u00F3
ó 211 \u00D3
ą 261 \u0105
Ą 260 \u0104
ś 347 \u015B
Ś 346 \u015A
ł 322 \u0142
Ł 321 \u0141
ż 380 \u017C
Ż 379 \u017B
ź 378 \u017A
Ź 377 \u0179
ć 263 \u0107
Ć 262 \u0106
ń 324 \u0144
Ń 323 \u0143
                 */
                this.AddParagraph("wydany przez podmiot certyfikuj\u0105cy:", _standardFont);
                this.AddParagraph("Zachodniopomorską Szkołę Biznesu w Szczecinie",_boldFont);
                this.AddParagraph(String.Format("w dniu {0:dd.MM.yyyy} roku", ExamDate), _standardFont);
                this.AddParagraph("Stwierdza się, że osoba " + StudentName + " ukończyła", _smallFont);
                this.AddParagraph("kurs przedsiębiorczości", _smallBoldFont);
                this.AddParagraph("w systemie e-learningowym eduKariera uzyskuj\u0105c stanowisko", _smallFont);
                this.AddParagraph(StudentEvaluationName, _smallBoldFont);
                this.AddParagraph("Jako weryfikację zdobytych kompetencji osoba " + StudentName, _smallFont);
                this.AddParagraph("zdała egzamin podsumowujący na ocenę " + StudentEndTestEvaluationName + ",", _smallFont);
                this.AddParagraph("co potwierdza posiadanie kompetencji z zakresu przedsiębiorczości.", _smallFont);

                EndDocument(DestinationFileName);
            }

            /// <summary>
            /// Ddoaje strone z tłem certyfikatu z określonego pliku
            /// Strona nie może mieć ustawionych marginesów aby tło było ładnie na cała stronę,
            /// strona typu A4
            /// </summary>
            /// <param name="doc"></param>
            /// <param name="BackgroundFileName"></param>
            private void AddNewPageWihtBackground(string BackgroundFileName)
            {
                XGraphicsState _state = _gfx.Save();
                XImage image = XImage.FromFile(BackgroundFileName);
                _gfx.DrawImage(image, 2, 2);
                _gfx.Restore(_state);
            }


            /// <summary>
            /// Tworzy dokument PDF i ustawia nagłówki oraz rozmiar strony,
            /// otwiera dokumenti przygotowuje go do wypelnienia
            /// </summary>
            /// <param name="ProjectName"></param>
            /// <param name="Title"></param>
            /// <param name="Author"></param>
            private void BeginDocument(string ProjectName, string Title, string Author, string FileName)
            {
                // Initialize the PDF document
                _document = new PdfDocument();

                // Add metadata to the document.  This information is visible when viewing the 
                // document properities within Adobe Reader.
                _document.Info.Title = ProjectName;
                _document.Info.Author = Author;
                _document.Info.Subject = Title;

                // Set the margins and page size
                this.SetStandardPageSize(_document);
            }

            private void EndDocument(string FileName)
            {
                // Clean up
                _document.Save(FileName);
            }

            /// <summary>
            /// Set margins and page size for the document
            /// </summary>
            /// <param name="doc"></param>
            private void SetStandardPageSize(PdfDocument doc)
            {
                // Create new page
                _page = doc.AddPage();
                _page.Size = PdfSharp.PageSize.A4;
                _gfx = XGraphics.FromPdfPage(_page);
            }

            int _paragraphsCount = 0;
            int _lineHeight = 30;
            int _top = 200;
            /// <summary>
            /// Add a paragraph object containing the specified element to the PDF document.
            /// </summary>
            /// <param name="doc">Document to which to add the paragraph.</param>
            /// <param name="alignment">Alignment of the paragraph.</param>
            /// <param name="font">Font to assign to the paragraph.</param>
            /// <param name="content">Object that is the content of the paragraph.</param>
            private void AddParagraph(string Content, XFont Font)
            {
                _gfx.DrawString(Content, Font, _fontColor, new XRect(0, _top + (_paragraphsCount * _lineHeight), _page.Width, _page.Height), XStringFormats.TopCenter);
                _paragraphsCount++;
            }            
        }
    }
}